/**
 * i-net software provides programming examples for illustration only, without warranty
 * either expressed or implied, including, but not limited to, the implied warranties
 * of merchantability and/or fitness for a particular purpose. This programming example
 * assumes that you are familiar with the programming language being demonstrated and
 * the tools used to create and debug procedures. i-net software support professionals
 * can help explain the functionality of a particular procedure, but they will not modify
 * these examples to provide added functionality or construct procedures to meet your
 * specific needs.
 *
 * Copyright © 1999-2026 i-net software GmbH, Berlin, Germany.
**/
package jdbc;

import java.util.HashMap;
import java.util.Map;

import javax.annotation.Nonnull;

import com.inet.report.Datasource;
import com.inet.report.Engine;
import com.inet.report.ReportException;
import com.inet.report.database.TableData;
import com.inet.report.database.TableSourceInfo;
import com.inet.report.database.fetch.DataCollector;
import com.inet.report.database.fetch.FetchTables;

/**
 * Simple example of a Database class which can be used as a data source for a report which does not connect to any
 * database but simply provides data as an Object[][].<br>
 * You can use this class at runtime to set the report data instead of using a JDBC database connection. The sample
 * {link DatabaseClassUsableInDesigner} contains a database class that can be used at design time and at runtime because
 * it also contains the database layout. To do this you have to 1) Create a Data Source Configuration with a
 * user-defined driver for this database class 2) Add this class to the class path of i-net Designer or i-net Clear
 * Reports 3) Set the name of the Data Source Configuration in the parameter "datasource" at runtime Create a Data
 * Source Configuration using the Data Source Manager: - select "user-defined driver" - set a name for the Data Source
 * Configuration, e.g. "DataWithoutJDBC" - set this class "samples.jdbc.DataWithoutJDBC" as Database Class for the Data
 * Source Configuration Adding to class path: To add this class file to the class path, you can create a jar file
 * containing this class (with command "jar cf custom-database-class.jar DatabaseWithoutJDBC.class") and copying the
 * created jar file into the directory "lib/driver" that is included in the installation directory of i-net Clear
 * Reports. In the report URL you have to set the name of the Data Source Configuration in the parameter "datasource":
 * ...datasource=DataWithoutJDBC...
 */
public class DataWithoutJDBC extends com.inet.report.Database {
    /**
     * {@inheritDoc}
     */
    @Override
    public @Nonnull Map<String, TableSourceInfo> getTableSourceInfos( @Nonnull Datasource ds, String catalog ) throws ReportException {
        HashMap<String, TableSourceInfo> map = new HashMap<>();
        map.put( "mytable", new TableSourceInfo( null, null, "mytable", TableSourceInfo.TYPE_TABLE ) );
        return map;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public void fetchData( Engine engine, FetchTables fetchTables, DataCollector dataCollector ) throws ReportException {
        String[] columns = { "ID", "Name" }; // need to be the same column name(s) as in the report
        /* Methods to see which report or subreport is working with this engine
        engine.getReportTitle();
        engine.getPrompts();
        ...
        */

        try {
            Object[][] data = { { Integer.valueOf( 10 ), "John" }, { Integer.valueOf( 20 ), "Peter" }, { Integer.valueOf( 23 ), "Ana" } };
            TableData tableData = new TableData( columns, data );
            dataCollector.addUnjoinedData( fetchTables.getTableSources().get( 0 ), tableData );
        } catch( Exception e ) {
            e.printStackTrace();
            //...
        }
    }
}
